#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Take a closer lookMod01.fsh   by   Plento
//https://www.shadertoy.com/view/NtdGWH
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Cole Peterson (Plento).

#define R iResolution.xy
#define m ((iMouse.xy - .5*R.xy) / R.y)
#define ss(a, b, x) smoothstep(a, b, x)
#define t iTime
#define rot(a) mat2(cos(a), -sin(a), sin(a), cos(a))

vec2 jules(vec2 uv){
    vec2 id = floor(uv);
    uv = fract(uv)-.5;
    
    if(int(id.x) % 2 == 0) uv.x *= -1.;
    if(int(id.y) % 2 == 0) uv.y *= -1.;
    
    vec2 z = uv;
    vec2 c = vec2(.36, .36);
    if(iMouse.z > 0.) c.y += m.x*0.05;
    
    float d = 99., x = 0., k = 0.;
    for(float i = 0.; i < 100.; i++){
        if (z.x * z.x + z.y * z.y > 4.0) return vec2(d, k);
         
        x = z.x * z.x - z.y * z.y + c.x;
        z.y = 2.0 * z.x * z.y + c.y;
        z.x = x;
        d = min(d, length(z));
        k++;
    }
    return vec2(d, k);
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = vec2(fragCoord.xy - .5*R.xy)/R.y;
    uv*=rot(t*.1);

    uv = .1*vec2(log(length(uv)), atan(uv.y, uv.x));
    uv.x -= t*.06;

    vec2 j = jules(uv);
    vec3 col = texture2D(texture0, j*.01).xyz;
    
    col *= ss(0.3, .06, j.x);
    col *= col * 1.7;
    fragColor = vec4(col, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

